#ifndef POINT_H
#define POINT_H

#include <vector>
#include <iostream>

/**
 * @brief Point class
 */
class Point
{
public:
	// constructors
	Point() = default;
	Point(Point const & point) = default;
	Point(int dimension);
	Point(Point const * point);
	Point(std::vector<double> const & coordinates);

	// operators
	double & operator[] (int index);
	double const & operator[] (int index) const;
	Point & operator+=(const Point & point);
	Point & operator-=(const Point & point);
	Point const operator+(Point const & x) const;
	Point const operator-(Point const & x) const;
	bool operator==(Point const & x) const;
	bool operator!=(Point const & x) const;

	// iterators
	std::vector<double>::const_iterator cbegin() const;
	std::vector<double>::const_iterator cend() const;

	// accessors / mutators
	int getDimension() const;

private:
	std::vector<double> coordinates;
	int dimension;
};

/**
 * @brief Dot product
 */
Point operator*(double s, Point const & x);

/**
 * @brief Scalar multiplication
 */
double operator*(Point const & x, Point const & y);

/**
 * @brief Output point to stream
 */
std::ostream& operator<<(std::ostream& stream, Point const& point);

#endif
