#include "ProbabilisticPoint.hpp"

ProbabilisticPoint::ProbabilisticPoint(std::vector<WeightedPoint> distribution) :
	distribution(distribution),
	weight(1),
	realizationProbability(0)
{
	for(auto const & x : this->distribution)
		realizationProbability += x.getWeight();
	
	if(realizationProbability > 1.0)
		throw("Realization probability > 1.0");
}

ProbabilisticPoint::ProbabilisticPoint(std::vector<WeightedPoint> distribution, double weight) :
	distribution(distribution),
	weight(weight),
	realizationProbability(0)
{
	for(auto const & x : this->distribution)
		realizationProbability += x.getWeight();
	
	if(realizationProbability > 1.0)
		throw("Realization probability > 1.0");
}

WeightedPoint & ProbabilisticPoint::operator[] (int index)
{
	return distribution[index];
}

WeightedPoint const & ProbabilisticPoint::operator[] (int index) const
{
	return distribution[index];
}

std::vector<WeightedPoint>::const_iterator ProbabilisticPoint::cbegin() const
{
	return distribution.cbegin();
}

std::vector<WeightedPoint>::const_iterator ProbabilisticPoint::cend() const
{
	return distribution.end();
}

void ProbabilisticPoint::setWeight(double weight)
{
	this->weight = weight;
}

unsigned int ProbabilisticPoint::getSizeOfDistribution() const
{
	return distribution.size();
}

double ProbabilisticPoint::getWeight() const
{
	return weight;
}

double ProbabilisticPoint::getRealizationProbability() const
{
	return realizationProbability;
}
